/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io;

import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.sysds.common.Types;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.data.TensorBlock;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.io.TensorReader;

public class TensorReaderTextCell
extends TensorReader {
    @Override
    public TensorBlock readTensorFromHDFS(String fname, long[] dims, int blen, Types.ValueType[] schema) throws IOException, DMLRuntimeException {
        JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        Path path = new Path(fname);
        FileSystem fs = IOUtilFunctions.getFileSystem(path, (Configuration)job);
        TensorReaderTextCell.checkValidInputFile(fs, path);
        return this.readTextCellTensorFromHDFS(path, job, dims, schema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TensorBlock readTextCellTensorFromHDFS(Path path, JobConf job, long[] dims, Types.ValueType[] schema) throws IOException {
        FileInputFormat.addInputPath((JobConf)job, (Path)path);
        TextInputFormat informat = new TextInputFormat();
        informat.configure(job);
        InputSplit[] splits = informat.getSplits(job, 1);
        LongWritable key = new LongWritable();
        Text value = new Text();
        int[] idims = Arrays.stream(dims).mapToInt(i -> (int)i).toArray();
        TensorBlock ret = schema.length == 1 ? new TensorBlock(schema[0], idims).allocateBlock() : new TensorBlock(schema, idims).allocateBlock();
        try {
            int[] ix = new int[dims.length];
            for (InputSplit split : splits) {
                RecordReader reader = informat.getRecordReader(split, job, Reporter.NULL);
                try {
                    while (reader.next((Object)key, (Object)value)) {
                        String[] parts = (String[])Arrays.stream(IOUtilFunctions.splitCSV(value.toString(), " ")).filter(s -> !s.isEmpty()).toArray(String[]::new);
                        for (int i2 = 0; i2 < ix.length; ++i2) {
                            ix[i2] = Integer.parseInt(parts[i2]) - 1;
                        }
                        ret.set(ix, parts[ix.length]);
                    }
                }
                finally {
                    IOUtilFunctions.closeSilently(reader);
                }
            }
        }
        catch (Exception ex) {
            throw new IOException("Unable to read tensor in text cell format.", ex);
        }
        return ret;
    }
}

