/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.resource.cost;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.sysds.common.Opcodes;
import org.apache.sysds.common.Types;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.lops.LeftIndex;
import org.apache.sysds.lops.MapMult;
import org.apache.sysds.parser.DMLProgram;
import org.apache.sysds.parser.DataIdentifier;
import org.apache.sysds.resource.CloudInstance;
import org.apache.sysds.resource.cost.CPCostUtils;
import org.apache.sysds.resource.cost.CostEstimationException;
import org.apache.sysds.resource.cost.IOCostUtils;
import org.apache.sysds.resource.cost.RDDStats;
import org.apache.sysds.resource.cost.SparkCostUtils;
import org.apache.sysds.resource.cost.VarStats;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.BasicProgramBlock;
import org.apache.sysds.runtime.controlprogram.ForProgramBlock;
import org.apache.sysds.runtime.controlprogram.FunctionProgramBlock;
import org.apache.sysds.runtime.controlprogram.IfProgramBlock;
import org.apache.sysds.runtime.controlprogram.Program;
import org.apache.sysds.runtime.controlprogram.ProgramBlock;
import org.apache.sysds.runtime.controlprogram.WhileProgramBlock;
import org.apache.sysds.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysds.runtime.instructions.Instruction;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.AggregateBinaryCPInstruction;
import org.apache.sysds.runtime.instructions.cp.AggregateUnaryCPInstruction;
import org.apache.sysds.runtime.instructions.cp.BinaryCPInstruction;
import org.apache.sysds.runtime.instructions.cp.BuiltinNaryCPInstruction;
import org.apache.sysds.runtime.instructions.cp.CPInstruction;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.CompressionCPInstruction;
import org.apache.sysds.runtime.instructions.cp.ComputationCPInstruction;
import org.apache.sysds.runtime.instructions.cp.CtableCPInstruction;
import org.apache.sysds.runtime.instructions.cp.DataGenCPInstruction;
import org.apache.sysds.runtime.instructions.cp.DeCompressionCPInstruction;
import org.apache.sysds.runtime.instructions.cp.FunctionCallCPInstruction;
import org.apache.sysds.runtime.instructions.cp.IndexingCPInstruction;
import org.apache.sysds.runtime.instructions.cp.MultiReturnBuiltinCPInstruction;
import org.apache.sysds.runtime.instructions.cp.MultiReturnParameterizedBuiltinCPInstruction;
import org.apache.sysds.runtime.instructions.cp.ParameterizedBuiltinCPInstruction;
import org.apache.sysds.runtime.instructions.cp.ParamservBuiltinCPInstruction;
import org.apache.sysds.runtime.instructions.cp.ReorgCPInstruction;
import org.apache.sysds.runtime.instructions.cp.ScalarBuiltinNaryCPInstruction;
import org.apache.sysds.runtime.instructions.cp.StringInitCPInstruction;
import org.apache.sysds.runtime.instructions.cp.UnaryCPInstruction;
import org.apache.sysds.runtime.instructions.cp.VariableCPInstruction;
import org.apache.sysds.runtime.instructions.spark.AggregateBinarySPInstruction;
import org.apache.sysds.runtime.instructions.spark.AggregateUnarySPInstruction;
import org.apache.sysds.runtime.instructions.spark.AggregateUnarySketchSPInstruction;
import org.apache.sysds.runtime.instructions.spark.AppendMSPInstruction;
import org.apache.sysds.runtime.instructions.spark.AppendSPInstruction;
import org.apache.sysds.runtime.instructions.spark.BinaryFrameFrameSPInstruction;
import org.apache.sysds.runtime.instructions.spark.BinaryFrameMatrixSPInstruction;
import org.apache.sysds.runtime.instructions.spark.BinaryMatrixBVectorSPInstruction;
import org.apache.sysds.runtime.instructions.spark.BinaryMatrixMatrixSPInstruction;
import org.apache.sysds.runtime.instructions.spark.BinaryMatrixScalarSPInstruction;
import org.apache.sysds.runtime.instructions.spark.BinarySPInstruction;
import org.apache.sysds.runtime.instructions.spark.CSVReblockSPInstruction;
import org.apache.sysds.runtime.instructions.spark.CastSPInstruction;
import org.apache.sysds.runtime.instructions.spark.CentralMomentSPInstruction;
import org.apache.sysds.runtime.instructions.spark.CheckpointSPInstruction;
import org.apache.sysds.runtime.instructions.spark.CtableSPInstruction;
import org.apache.sysds.runtime.instructions.spark.IndexingSPInstruction;
import org.apache.sysds.runtime.instructions.spark.LIBSVMReblockSPInstruction;
import org.apache.sysds.runtime.instructions.spark.MapmmChainSPInstruction;
import org.apache.sysds.runtime.instructions.spark.MapmmSPInstruction;
import org.apache.sysds.runtime.instructions.spark.MatrixIndexingSPInstruction;
import org.apache.sysds.runtime.instructions.spark.MatrixReshapeSPInstruction;
import org.apache.sysds.runtime.instructions.spark.PMapmmSPInstruction;
import org.apache.sysds.runtime.instructions.spark.ParameterizedBuiltinSPInstruction;
import org.apache.sysds.runtime.instructions.spark.PmmSPInstruction;
import org.apache.sysds.runtime.instructions.spark.QuantileSortSPInstruction;
import org.apache.sysds.runtime.instructions.spark.QuaternarySPInstruction;
import org.apache.sysds.runtime.instructions.spark.RandSPInstruction;
import org.apache.sysds.runtime.instructions.spark.ReblockSPInstruction;
import org.apache.sysds.runtime.instructions.spark.ReorgSPInstruction;
import org.apache.sysds.runtime.instructions.spark.SPInstruction;
import org.apache.sysds.runtime.instructions.spark.TernarySPInstruction;
import org.apache.sysds.runtime.instructions.spark.Tsmm2SPInstruction;
import org.apache.sysds.runtime.instructions.spark.TsmmSPInstruction;
import org.apache.sysds.runtime.instructions.spark.UnaryFrameSPInstruction;
import org.apache.sysds.runtime.instructions.spark.UnaryMatrixSPInstruction;
import org.apache.sysds.runtime.instructions.spark.UnarySPInstruction;
import org.apache.sysds.runtime.instructions.spark.WriteSPInstruction;
import org.apache.sysds.runtime.instructions.spark.ZipmmSPInstruction;
import org.apache.sysds.runtime.meta.DataCharacteristics;
import org.apache.sysds.runtime.meta.MetaDataFormat;

public class CostEstimator {
    private static final long MIN_MEMORY_TO_TRACK = 0x100000L;
    private static final int DEFAULT_NUM_ITER = 10;
    private static final double MEM_ALLOCATION_LIMIT_FRACTION = 0.9;
    private final Program _program;
    private final HashMap<String, VarStats> _stats;
    private final HashSet<String> _functions;
    private final long localMemoryLimit;
    private long freeLocalMemory;
    private final IOCostUtils.IOMetrics driverMetrics;
    private final IOCostUtils.IOMetrics executorMetrics;

    public static double estimateExecutionTime(Program program, CloudInstance driverNode, CloudInstance executorNode) throws CostEstimationException {
        CostEstimator estimator = new CostEstimator(program, driverNode, executorNode);
        return estimator.getTimeEstimate();
    }

    public CostEstimator(Program program, CloudInstance driverNode, CloudInstance executorNode) {
        this._program = program;
        this._stats = new HashMap();
        this._functions = new HashSet();
        this.freeLocalMemory = this.localMemoryLimit = (long)(OptimizerUtils.getLocalMemBudget() * 0.9);
        this.driverMetrics = new IOCostUtils.IOMetrics(driverNode);
        if (executorNode == null) {
            this.executorMetrics = null;
        } else {
            int dedicatedExecutorCores = SparkExecutionContext.getDefaultParallelism(false) / SparkExecutionContext.getNumExecutors();
            long effectiveExecutorFlops = (long)((double)executorNode.getFLOPS() * ((double)executorNode.getVCPUs() / (double)dedicatedExecutorCores));
            this.executorMetrics = new IOCostUtils.IOMetrics(effectiveExecutorFlops, dedicatedExecutorCores, executorNode.getMemoryBandwidth(), executorNode.getDiskReadBandwidth(), executorNode.getDiskWriteBandwidth(), executorNode.getNetworkBandwidth());
        }
    }

    public void putStats(HashMap<String, VarStats> inputStats) {
        this._stats.putAll(inputStats);
    }

    public VarStats getStats(String statsName) {
        VarStats result = this._stats.get(statsName);
        if (result == null) {
            throw new RuntimeException(statsName + " key not imported yet");
        }
        return result;
    }

    public VarStats getStatsWithDefaultScalar(String statsName) {
        VarStats result = this._stats.get(statsName);
        if (result == null) {
            result = new VarStats(statsName, null);
        }
        return result;
    }

    public double getTimeEstimate() throws CostEstimationException {
        double costs = 0.0;
        for (ProgramBlock pb : this._program.getProgramBlocks()) {
            costs += this.getTimeEstimatePB(pb);
        }
        return costs;
    }

    private double getTimeEstimatePB(ProgramBlock pb) throws CostEstimationException {
        double ret;
        block13: {
            block14: {
                block12: {
                    ret = 0.0;
                    if (!(pb instanceof WhileProgramBlock)) break block12;
                    WhileProgramBlock tmp = (WhileProgramBlock)pb;
                    for (ProgramBlock pb2 : tmp.getChildBlocks()) {
                        ret += this.getTimeEstimatePB(pb2);
                    }
                    ret *= 10.0;
                    break block13;
                }
                if (!(pb instanceof IfProgramBlock)) break block14;
                IfProgramBlock tmp = (IfProgramBlock)pb;
                for (ProgramBlock pb2 : tmp.getChildBlocksIfBody()) {
                    ret += this.getTimeEstimatePB(pb2);
                }
                if (tmp.getChildBlocksElseBody() == null) break block13;
                for (ProgramBlock pb2 : tmp.getChildBlocksElseBody()) {
                    ret += this.getTimeEstimatePB(pb2);
                    ret /= 2.0;
                }
                break block13;
            }
            if (pb instanceof ForProgramBlock) {
                ForProgramBlock tmp = (ForProgramBlock)pb;
                for (ProgramBlock pb2 : tmp.getChildBlocks()) {
                    ret += this.getTimeEstimatePB(pb2);
                }
                ret *= (double)OptimizerUtils.getNumIterations(tmp, 10L);
            } else if (pb instanceof FunctionProgramBlock) {
                FunctionProgramBlock tmp = (FunctionProgramBlock)pb;
                for (ProgramBlock pb2 : tmp.getChildBlocks()) {
                    ret += this.getTimeEstimatePB(pb2);
                }
            } else if (pb instanceof BasicProgramBlock) {
                BasicProgramBlock bpb = (BasicProgramBlock)pb;
                ArrayList<Instruction> tmp = bpb.getInstructions();
                for (Instruction inst : tmp) {
                    if (inst instanceof FunctionCallCPInstruction) {
                        FunctionCallCPInstruction finst = (FunctionCallCPInstruction)inst;
                        String fkey = DMLProgram.constructFunctionKey(finst.getNamespace(), finst.getFunctionName());
                        if (this._functions.contains(fkey) || pb.getProgram() == null) continue;
                        this._functions.add(fkey);
                        this.maintainFCallInputStats(finst);
                        FunctionProgramBlock fpb = this._program.getFunctionProgramBlock(fkey, true);
                        ret = this.getTimeEstimatePB(fpb);
                        this.maintainFCallOutputStats(finst, fpb);
                        this._functions.remove(fkey);
                        continue;
                    }
                    this.maintainStats(inst);
                    ret += this.getTimeEstimateInst(inst);
                }
            }
        }
        return ret;
    }

    public void maintainFCallInputStats(FunctionCallCPInstruction finst) {
        CPOperand[] inputs = finst.getInputs();
        for (int i = 0; i < inputs.length; ++i) {
            Types.DataType dt = inputs[i].getDataType();
            if (dt == Types.DataType.TENSOR) {
                throw new DMLRuntimeException("Tensor is not supported for cost estimation");
            }
            if (dt != Types.DataType.MATRIX && dt != Types.DataType.FRAME && dt != Types.DataType.LIST) continue;
            String argName = finst.getFunArgNames().get(i);
            VarStats argStats = this.getStats(inputs[i].getName());
            if (inputs[i].getName().equals(argName)) {
                if (argStats != this._stats.get(argName)) {
                    throw new RuntimeException("Overriding referenced variable within a function call is not a handled case");
                }
                ++argStats.selfRefCount;
                continue;
            }
            ++argStats.refCount;
            this._stats.put(finst.getFunArgNames().get(i), argStats);
        }
    }

    public void maintainFCallOutputStats(FunctionCallCPInstruction finst, FunctionProgramBlock fpb) {
        ArrayList<DataIdentifier> params = fpb.getOutputParams();
        List<String> boundNames = finst.getBoundOutputParamNames();
        for (int i = 0; i < boundNames.size(); ++i) {
            Types.DataType dt = ((DataIdentifier)params.get(i)).getDataType();
            if (dt == Types.DataType.TENSOR) {
                throw new DMLRuntimeException("Tensor is not supported for cost estimation");
            }
            if (dt != Types.DataType.MATRIX && dt != Types.DataType.FRAME && dt != Types.DataType.LIST) continue;
            VarStats boundStats = this.getStats(((DataIdentifier)params.get(i)).getName());
            ++boundStats.refCount;
            this._stats.put(boundNames.get(i), boundStats);
        }
    }

    public void maintainStats(Instruction inst) {
        block35: {
            block34: {
                if (!(inst instanceof VariableCPInstruction)) break block34;
                String opcode = inst.getOpcode();
                VariableCPInstruction vinst = (VariableCPInstruction)inst;
                if (vinst.getInput1().getDataType() == Types.DataType.TENSOR) {
                    throw new DMLRuntimeException("Tensor is not supported for cost estimation");
                }
                String varName = vinst.getInput1().getName();
                switch (opcode) {
                    case "createvar": {
                        DataCharacteristics dataCharacteristics = vinst.getMetaData().getDataCharacteristics();
                        if (!dataCharacteristics.nnzKnown()) {
                            dataCharacteristics.setNonZeros(dataCharacteristics.getLength());
                        }
                        VarStats varStats = new VarStats(varName, dataCharacteristics);
                        if (vinst.getInput1().getName().startsWith("pREAD")) {
                            String fileName = vinst.getInput2().getName();
                            String dataSource = IOCostUtils.getDataSource(fileName);
                            varStats.fileInfo = new Object[]{dataSource, ((MetaDataFormat)vinst.getMetaData()).getFileFormat()};
                        }
                        this._stats.put(varName, varStats);
                        break;
                    }
                    case "cpvar": {
                        VarStats outputStats = this.getStats(varName);
                        this._stats.put(vinst.getInput2().getName(), outputStats);
                        ++outputStats.refCount;
                        break;
                    }
                    case "mvvar": {
                        VarStats statsToMove = this._stats.remove(varName);
                        String newName = vinst.getInput2().getName();
                        if (statsToMove != null) {
                            statsToMove.varName = newName;
                        }
                        this._stats.put(newName, statsToMove);
                        break;
                    }
                    case "rmvar": {
                        for (CPOperand inputOperand : vinst.getInputs()) {
                            VarStats inputVar = this._stats.remove(inputOperand.getName());
                            if (inputVar == null) continue;
                            if (--inputVar.selfRefCount > 0) {
                                this._stats.put(inputOperand.getName(), inputVar);
                                continue;
                            }
                            if (--inputVar.refCount >= 1) continue;
                            this.removeFromMemory(inputVar);
                        }
                        break block35;
                    }
                    case "castdts": {
                        VarStats scalarStats = new VarStats(vinst.getOutputVariableName(), null);
                        this._stats.put(vinst.getOutputVariableName(), scalarStats);
                        break;
                    }
                    case "write": {
                        String fileName = vinst.getInput2().isLiteral() ? vinst.getInput2().getLiteral().getStringValue() : "hdfs_file";
                        String dataSource = IOCostUtils.getDataSource(fileName);
                        String formatString = vinst.getInput3().getLiteral().getStringValue();
                        this._stats.get((Object)varName).fileInfo = new Object[]{dataSource, Types.FileFormat.safeValueOf(formatString)};
                    }
                }
                break block35;
            }
            if (inst instanceof DataGenCPInstruction) {
                String opcode = inst.getOpcode();
                if (opcode.equals("rand")) {
                    DataGenCPInstruction dinst = (DataGenCPInstruction)inst;
                    VarStats stat = this.getStats(dinst.getOutput().getName());
                    stat.characteristics.setNonZeros((long)((double)stat.getCells() * dinst.getSparsity()));
                }
            } else if (inst instanceof AggregateUnaryCPInstruction) {
                VarStats outputStats;
                String opcode = inst.getOpcode();
                if (!(opcode.equals("nrow") || opcode.equals("ncol") || opcode.equals("length"))) {
                    return;
                }
                AggregateUnaryCPInstruction auinst = (AggregateUnaryCPInstruction)inst;
                VarStats inputStats = this.getStats(auinst.input1.getName());
                String outputName = auinst.getOutputVariableName();
                if (opcode.equals("nrow")) {
                    if (inputStats.getM() < 0L) {
                        return;
                    }
                    outputStats = new VarStats(String.valueOf(inputStats.getM()), null);
                } else if (opcode.equals("ncol")) {
                    if (inputStats.getN() < 0L) {
                        return;
                    }
                    outputStats = new VarStats(String.valueOf(inputStats.getN()), null);
                } else {
                    if (inputStats.getCells() < 0L) {
                        return;
                    }
                    outputStats = new VarStats(String.valueOf(inputStats.getCells()), null);
                }
                this._stats.put(outputName, outputStats);
            }
        }
    }

    public double getTimeEstimateInst(Instruction inst) throws CostEstimationException {
        double timeEstimate = inst instanceof CPInstruction ? this.getTimeEstimateCPInst((CPInstruction)inst) : this.parseSPInst((SPInstruction)inst);
        return timeEstimate;
    }

    public double getTimeEstimateCPInst(CPInstruction inst) throws CostEstimationException {
        double time = 0.0;
        VarStats output = null;
        if (inst instanceof VariableCPInstruction) {
            String opcode = inst.getOpcode();
            VariableCPInstruction vinst = (VariableCPInstruction)inst;
            VarStats input = null;
            if (opcode.startsWith("cast")) {
                input = this.getStatsWithDefaultScalar(vinst.getInput1().getName());
                output = this.getStatsWithDefaultScalar(vinst.getOutput().getName());
                CPCostUtils.assignOutputMemoryStats(inst, output, input);
            } else if (opcode.equals(Opcodes.WRITE.toString())) {
                input = this.getStatsWithDefaultScalar(vinst.getInput1().getName());
                time += IOCostUtils.getFileSystemWriteTime(input, this.driverMetrics);
            }
            time += input == null ? 0.0 : this.loadCPVarStatsAndEstimateTime(input);
            time += CPCostUtils.getVariableInstTime(vinst, input, output, this.driverMetrics);
        } else if (inst instanceof UnaryCPInstruction) {
            UnaryCPInstruction uinst = (UnaryCPInstruction)inst;
            output = this.getStatsWithDefaultScalar(uinst.getOutput().getName());
            if (inst instanceof DataGenCPInstruction || inst instanceof StringInitCPInstruction) {
                String[] s = InstructionUtils.getInstructionParts(uinst.getInstructionString());
                VarStats rows = this.getStatsWithDefaultScalar(s[1]);
                VarStats cols = this.getStatsWithDefaultScalar(s[2]);
                CPCostUtils.assignOutputMemoryStats(inst, output, rows, cols);
                time += CPCostUtils.getDataGenCPInstTime(uinst, output, this.driverMetrics);
            } else {
                VarStats weights;
                VarStats input = this.getStatsWithDefaultScalar(uinst.input1.getName());
                VarStats varStats = weights = uinst.input2 == null || uinst.input2.isScalar() ? null : this.getStats(uinst.input2.getName());
                if (inst instanceof IndexingCPInstruction) {
                    IndexingCPInstruction idxInst = (IndexingCPInstruction)inst;
                    VarStats rowLower = this.getStatsWithDefaultScalar(idxInst.getRowLower().getName());
                    VarStats rowUpper = this.getStatsWithDefaultScalar(idxInst.getRowUpper().getName());
                    VarStats colLower = this.getStatsWithDefaultScalar(idxInst.getColLower().getName());
                    VarStats colUpper = this.getStatsWithDefaultScalar(idxInst.getColUpper().getName());
                    CPCostUtils.assignOutputMemoryStats(inst, output, input, weights, rowLower, rowUpper, colLower, colUpper);
                } else if (inst instanceof ReorgCPInstruction && inst.getOpcode().equals(Opcodes.SORT.toString())) {
                    ReorgCPInstruction reorgInst = (ReorgCPInstruction)inst;
                    VarStats ixRet = this.getStatsWithDefaultScalar(reorgInst.getIxRet().getName());
                    CPCostUtils.assignOutputMemoryStats(inst, output, input, ixRet);
                } else {
                    CPCostUtils.assignOutputMemoryStats(inst, output, input);
                }
                if (CPCostUtils.opcodeRequiresScan(inst.getOpcode())) {
                    time += this.loadCPVarStatsAndEstimateTime(input);
                }
                time += weights == null ? 0.0 : this.loadCPVarStatsAndEstimateTime(weights);
                time += CPCostUtils.getUnaryInstTime(uinst, input, weights, output, this.driverMetrics);
            }
        } else if (inst instanceof BinaryCPInstruction) {
            BinaryCPInstruction binst = (BinaryCPInstruction)inst;
            VarStats input1 = this.getStatsWithDefaultScalar(binst.input1.getName());
            VarStats input2 = this.getStatsWithDefaultScalar(binst.input2.getName());
            VarStats weights = binst.input3 == null ? null : this.getStatsWithDefaultScalar(binst.input3.getName());
            output = this.getStatsWithDefaultScalar(binst.output.getName());
            if (inst instanceof AggregateBinaryCPInstruction) {
                AggregateBinaryCPInstruction aggBinInst = (AggregateBinaryCPInstruction)inst;
                VarStats transposeLeft = new VarStats(String.valueOf(aggBinInst.transposeLeft), null);
                VarStats transposeRight = new VarStats(String.valueOf(aggBinInst.transposeRight), null);
                CPCostUtils.assignOutputMemoryStats(inst, output, input1, input2, transposeLeft, transposeRight);
            } else {
                CPCostUtils.assignOutputMemoryStats(inst, output, input1, input2);
            }
            time += this.loadCPVarStatsAndEstimateTime(input1);
            time += this.loadCPVarStatsAndEstimateTime(input2);
            time += weights == null ? 0.0 : this.loadCPVarStatsAndEstimateTime(weights);
            time += CPCostUtils.getBinaryInstTime(binst, input1, input2, weights, output, this.driverMetrics);
        } else if (inst instanceof ParameterizedBuiltinCPInstruction) {
            if (inst instanceof ParamservBuiltinCPInstruction) {
                throw new RuntimeException("ParamservBuiltinCPInstruction is not supported for estimation");
            }
            ParameterizedBuiltinCPInstruction pinst = (ParameterizedBuiltinCPInstruction)inst;
            VarStats input1 = this.getParameterizedBuiltinParamStats("target", pinst.getParameterMap(), true);
            VarStats input2 = null;
            switch (inst.getOpcode()) {
                case "rmempty": {
                    input2 = this.getParameterizedBuiltinParamStats("select", pinst.getParameterMap(), false);
                    break;
                }
                case "contains": {
                    input2 = this.getParameterizedBuiltinParamStats("pattern", pinst.getParameterMap(), false);
                    break;
                }
                case "groupedagg": {
                    input2 = this.getParameterizedBuiltinParamStats("groups", pinst.getParameterMap(), false);
                }
            }
            output = this.getStatsWithDefaultScalar(pinst.getOutputVariableName());
            CPCostUtils.assignOutputMemoryStats(inst, output, input1, input2);
            time += input1 != null ? this.loadCPVarStatsAndEstimateTime(input1) : 0.0;
            time += input2 != null ? this.loadCPVarStatsAndEstimateTime(input2) : 0.0;
            time += CPCostUtils.getParameterizedBuiltinInstTime(pinst, input1, output, this.driverMetrics);
        } else {
            if (inst instanceof MultiReturnBuiltinCPInstruction) {
                MultiReturnBuiltinCPInstruction mrbinst = (MultiReturnBuiltinCPInstruction)inst;
                VarStats input = this.getStats(mrbinst.input1.getName());
                VarStats[] outputs = new VarStats[mrbinst.getOutputs().size()];
                int i = 0;
                for (CPOperand operand : mrbinst.getOutputs()) {
                    VarStats current;
                    if (!operand.isMatrix()) {
                        throw new DMLRuntimeException("MultiReturnBuiltinCPInstruction expects only matrix output objects");
                    }
                    outputs[i] = current = this.getStats(operand.getName());
                    ++i;
                }
                CPCostUtils.assignOutputMemoryStats(inst, input, outputs);
                for (VarStats current : outputs) {
                    this.putInMemory(current);
                }
                time += this.loadCPVarStatsAndEstimateTime(input);
                return time += CPCostUtils.getMultiReturnBuiltinInstTime(mrbinst, input, outputs, this.driverMetrics);
            }
            if (inst instanceof ComputationCPInstruction) {
                if (inst instanceof MultiReturnParameterizedBuiltinCPInstruction || inst instanceof CompressionCPInstruction || inst instanceof DeCompressionCPInstruction) {
                    throw new RuntimeException(inst.getClass().getName() + " is not supported for estimation");
                }
                ComputationCPInstruction cinst = (ComputationCPInstruction)inst;
                VarStats input1 = this.getStatsWithDefaultScalar(cinst.input1.getName());
                VarStats input2 = cinst.input2 == null ? null : this.getStatsWithDefaultScalar(cinst.input2.getName());
                VarStats input3 = cinst.input3 == null ? null : this.getStatsWithDefaultScalar(cinst.input3.getName());
                VarStats input4 = cinst.input4 == null ? null : this.getStatsWithDefaultScalar(cinst.input4.getName());
                output = this.getStatsWithDefaultScalar(cinst.getOutput().getName());
                if (inst instanceof CtableCPInstruction) {
                    CtableCPInstruction tableInst = (CtableCPInstruction)inst;
                    VarStats outDim1 = this.getCTableDim(tableInst.getOutDim1());
                    VarStats outDim2 = this.getCTableDim(tableInst.getOutDim2());
                    CPCostUtils.assignOutputMemoryStats(inst, output, input1, input2, outDim1, outDim2);
                } else {
                    CPCostUtils.assignOutputMemoryStats(inst, output, input1, input2, input3, input4);
                }
                time += this.loadCPVarStatsAndEstimateTime(input1);
                time += input2 == null ? 0.0 : this.loadCPVarStatsAndEstimateTime(input2);
                time += input3 == null ? 0.0 : this.loadCPVarStatsAndEstimateTime(input3);
                time += input4 == null ? 0.0 : this.loadCPVarStatsAndEstimateTime(input4);
                time += CPCostUtils.getComputationInstTime(cinst, input1, input2, input3, input4, output, this.driverMetrics);
            } else if (inst instanceof BuiltinNaryCPInstruction) {
                BuiltinNaryCPInstruction bninst = (BuiltinNaryCPInstruction)inst;
                output = this.getStatsWithDefaultScalar(bninst.getOutput().getName());
                if (bninst instanceof ScalarBuiltinNaryCPInstruction) {
                    return CPCostUtils.getBuiltinNaryInstTime(bninst, null, output, this.driverMetrics);
                }
                VarStats[] inputs = new VarStats[bninst.getInputs().length];
                int i = 0;
                for (CPOperand operand : bninst.getInputs()) {
                    if (!operand.isMatrix()) continue;
                    VarStats input = this.getStatsWithDefaultScalar(operand.getName());
                    time += this.loadCPVarStatsAndEstimateTime(input);
                    inputs[i] = input;
                    ++i;
                }
                inputs = Arrays.copyOf(inputs, i + 1);
                CPCostUtils.assignOutputMemoryStats(inst, output, inputs);
                time += CPCostUtils.getBuiltinNaryInstTime(bninst, inputs, output, this.driverMetrics);
            } else {
                throw new RuntimeException(inst.getClass().getName() + " is not supported for estimation");
            }
        }
        if (output != null) {
            this.putInMemory(output);
        }
        if (time < 0.0) {
            throw new RuntimeException("Unexpected negative value at estimating CP instruction execution time");
        }
        if (time == Double.POSITIVE_INFINITY) {
            throw new RuntimeException("Unexpected infinity value at estimating CP instruction execution time");
        }
        return time;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double parseSPInst(SPInstruction inst) throws CostEstimationException {
        BinarySPInstruction binst;
        VarStats output;
        UnarySPInstruction uinst;
        if (inst instanceof ReblockSPInstruction || inst instanceof CSVReblockSPInstruction || inst instanceof LIBSVMReblockSPInstruction) {
            uinst = (UnarySPInstruction)inst;
            VarStats input = this.getStats(uinst.input1.getName());
            output = this.getStats(uinst.getOutputVariableName());
            SparkCostUtils.assignOutputRDDStats(inst, output, input);
            output.fileInfo = input.fileInfo;
            output.rddStats.hashPartitioned = true;
            output.rddStats.cost = SparkCostUtils.getReblockInstTime(inst.getOpcode(), input, output, this.executorMetrics);
        } else if (inst instanceof CheckpointSPInstruction) {
            CheckpointSPInstruction cinst = (CheckpointSPInstruction)inst;
            VarStats input = this.getStats(cinst.input1.getName());
            double loadTime = this.loadRDDStatsAndEstimateTime(input);
            output = this.getStats(cinst.getOutputVariableName());
            SparkCostUtils.assignOutputRDDStats(inst, output, input);
            output.fileInfo = input.fileInfo;
            output.rddStats.checkpoint = true;
            output.rddStats.cost = loadTime;
        } else if (inst instanceof RandSPInstruction) {
            RandSPInstruction rinst = (RandSPInstruction)inst;
            String opcode = rinst.getOpcode();
            int randType = -1;
            if (opcode.equals("rand") || opcode.equals("frame")) {
                randType = rinst.getMinValue() == 0.0 && rinst.getMaxValue() == 0.0 ? 0 : (rinst.getSparsity() == 1.0 && rinst.getMinValue() == rinst.getMaxValue() ? 1 : 2);
            }
            output = this.getStats(rinst.output.getName());
            SparkCostUtils.assignOutputRDDStats(inst, output, new VarStats[0]);
            output.rddStats.cost = SparkCostUtils.getRandInstTime(opcode, randType, output, this.executorMetrics);
        } else if (inst instanceof AggregateUnarySPInstruction || inst instanceof AggregateUnarySketchSPInstruction) {
            UnarySPInstruction auinst = (UnarySPInstruction)inst;
            VarStats input = this.getStats(auinst.input1.getName());
            double loadTime = this.loadRDDStatsAndEstimateTime(input);
            output = this.getStats(auinst.getOutputVariableName());
            SparkCostUtils.assignOutputRDDStats(inst, output, input);
            output.rddStats.cost = loadTime + SparkCostUtils.getAggUnaryInstTime(auinst, input, output, this.executorMetrics);
        } else if (inst instanceof IndexingSPInstruction) {
            VarStats input1;
            IndexingSPInstruction ixdinst = (IndexingSPInstruction)inst;
            boolean isLeftCacheType = inst instanceof MatrixIndexingSPInstruction && ((MatrixIndexingSPInstruction)ixdinst).getLixType() == LeftIndex.LixCacheType.LEFT;
            VarStats input2 = null;
            double loadTime = 0.0;
            if (ixdinst.getOpcode().toLowerCase().contains("left")) {
                if (isLeftCacheType) {
                    input1 = this.getStats(ixdinst.input2.getName());
                    input2 = this.getStats(ixdinst.input1.getName());
                } else {
                    input1 = this.getStats(ixdinst.input1.getName());
                    input2 = this.getStats(ixdinst.input2.getName());
                }
                loadTime = ixdinst.getOpcode().equals(Opcodes.LEFT_INDEX.toString()) ? (loadTime += this.loadRDDStatsAndEstimateTime(input2)) : (loadTime += this.loadBroadcastVarStatsAndEstimateTime(input2));
            } else {
                input1 = this.getStats(ixdinst.input1.getName());
            }
            loadTime += this.loadRDDStatsAndEstimateTime(input1);
            VarStats rowLower = this.getStatsWithDefaultScalar(ixdinst.getRowLower().getName());
            VarStats rowUpper = this.getStatsWithDefaultScalar(ixdinst.getRowUpper().getName());
            VarStats colLower = this.getStatsWithDefaultScalar(ixdinst.getColLower().getName());
            VarStats colUpper = this.getStatsWithDefaultScalar(ixdinst.getColUpper().getName());
            output = this.getStats(ixdinst.getOutputVariableName());
            SparkCostUtils.assignOutputRDDStats(inst, output, input1, input2, rowLower, rowUpper, colLower, colUpper);
            output.rddStats.cost = loadTime + SparkCostUtils.getIndexingInstTime(ixdinst, input1, input2, output, this.driverMetrics, this.executorMetrics);
        } else if (inst instanceof UnarySPInstruction) {
            uinst = (UnarySPInstruction)inst;
            VarStats input = this.getStats(uinst.input1.getName());
            double loadTime = this.loadRDDStatsAndEstimateTime(input);
            output = this.getStats(uinst.getOutputVariableName());
            if (uinst instanceof UnaryMatrixSPInstruction || inst instanceof UnaryFrameSPInstruction) {
                SparkCostUtils.assignOutputRDDStats(inst, output, input);
                output.rddStats.cost = loadTime + SparkCostUtils.getUnaryInstTime(uinst.getOpcode(), input, output, this.executorMetrics);
            } else if (uinst instanceof ReorgSPInstruction || inst instanceof MatrixReshapeSPInstruction) {
                if (uinst instanceof ReorgSPInstruction && uinst.getOpcode().equals(Opcodes.SORT.toString())) {
                    ReorgSPInstruction reorgInst = (ReorgSPInstruction)inst;
                    VarStats ixRet = this.getStatsWithDefaultScalar(reorgInst.getIxRet().getName());
                    SparkCostUtils.assignOutputRDDStats(inst, output, input, ixRet);
                } else {
                    SparkCostUtils.assignOutputRDDStats(inst, output, input);
                }
                output.rddStats.cost = loadTime + SparkCostUtils.getReorgInstTime(uinst, input, output, this.executorMetrics);
            } else if (uinst instanceof TsmmSPInstruction || inst instanceof Tsmm2SPInstruction) {
                SparkCostUtils.assignOutputRDDStats(inst, output, input);
                output.rddStats.cost = loadTime + SparkCostUtils.getTSMMInstTime(uinst, input, output, this.driverMetrics, this.executorMetrics);
            } else if (uinst instanceof CentralMomentSPInstruction) {
                VarStats weights = null;
                if (uinst.input3 != null) {
                    weights = this.getStats(uinst.input2.getName());
                    loadTime += this.loadRDDStatsAndEstimateTime(weights);
                }
                SparkCostUtils.assignOutputRDDStats(inst, output, input, weights);
                output.rddStats.cost = loadTime + SparkCostUtils.getCentralMomentInstTime((CentralMomentSPInstruction)uinst, input, weights, output, this.executorMetrics);
            } else if (inst instanceof CastSPInstruction) {
                SparkCostUtils.assignOutputRDDStats(inst, output, input);
                output.rddStats.cost = loadTime + SparkCostUtils.getCastInstTime((CastSPInstruction)inst, input, output, this.executorMetrics);
            } else {
                if (!(inst instanceof QuantileSortSPInstruction)) throw new RuntimeException("Unsupported Unary Spark instruction of type " + inst.getClass().getName());
                VarStats weights = null;
                if (uinst.input2 != null) {
                    weights = this.getStats(uinst.input2.getName());
                    loadTime += this.loadRDDStatsAndEstimateTime(weights);
                }
                SparkCostUtils.assignOutputRDDStats(inst, output, input, weights);
                output.rddStats.cost = loadTime + SparkCostUtils.getQSortInstTime((QuantileSortSPInstruction)uinst, input, weights, output, this.executorMetrics);
            }
        } else if (inst instanceof BinaryFrameFrameSPInstruction || inst instanceof BinaryFrameMatrixSPInstruction || inst instanceof BinaryMatrixMatrixSPInstruction || inst instanceof BinaryMatrixScalarSPInstruction) {
            binst = (BinarySPInstruction)inst;
            VarStats input1 = this.getStatsWithDefaultScalar(binst.input1.getName());
            VarStats input2 = this.getStatsWithDefaultScalar(binst.input2.getName());
            double loadTime = this.loadRDDStatsAndEstimateTime(input1);
            loadTime = inst instanceof BinaryMatrixBVectorSPInstruction ? (loadTime += this.loadBroadcastVarStatsAndEstimateTime(input2)) : (loadTime += this.loadRDDStatsAndEstimateTime(input2));
            output = this.getStats(binst.getOutputVariableName());
            SparkCostUtils.assignOutputRDDStats(inst, output, input1, input2);
            output.rddStats.cost = loadTime + SparkCostUtils.getBinaryInstTime(inst, input1, input2, output, this.driverMetrics, this.executorMetrics);
        } else if (inst instanceof AppendSPInstruction) {
            AppendSPInstruction ainst = (AppendSPInstruction)inst;
            VarStats input1 = this.getStats(ainst.input1.getName());
            double loadTime = this.loadRDDStatsAndEstimateTime(input1);
            VarStats input2 = this.getStats(ainst.input2.getName());
            loadTime = ainst instanceof AppendMSPInstruction ? (loadTime += this.loadBroadcastVarStatsAndEstimateTime(input2)) : (loadTime += this.loadRDDStatsAndEstimateTime(input2));
            output = this.getStats(ainst.getOutputVariableName());
            SparkCostUtils.assignOutputRDDStats(inst, output, input1, input2);
            output.rddStats.cost = loadTime + SparkCostUtils.getAppendInstTime(ainst, input1, input2, output, this.driverMetrics, this.executorMetrics);
        } else if (inst instanceof AggregateBinarySPInstruction || inst instanceof PmmSPInstruction || inst instanceof PMapmmSPInstruction || inst instanceof ZipmmSPInstruction) {
            VarStats input2;
            VarStats input1;
            binst = (BinarySPInstruction)inst;
            double loadTime = 0.0;
            if (binst instanceof MapmmSPInstruction || binst instanceof PmmSPInstruction) {
                MapMult.CacheType cacheType;
                MapMult.CacheType cacheType2 = cacheType = binst instanceof MapmmSPInstruction ? ((MapmmSPInstruction)binst).getCacheType() : ((PmmSPInstruction)binst).getCacheType();
                if (cacheType.isRight()) {
                    input1 = this.getStats(binst.input1.getName());
                    input2 = this.getStats(binst.input2.getName());
                } else {
                    input1 = this.getStats(binst.input2.getName());
                    input2 = this.getStats(binst.input1.getName());
                }
                loadTime += this.loadRDDStatsAndEstimateTime(input1);
                loadTime += this.loadBroadcastVarStatsAndEstimateTime(input2);
            } else {
                input1 = this.getStats(binst.input1.getName());
                input2 = this.getStats(binst.input2.getName());
                loadTime += this.loadRDDStatsAndEstimateTime(input1);
                loadTime += this.loadRDDStatsAndEstimateTime(input2);
            }
            output = this.getStats(binst.getOutputVariableName());
            SparkCostUtils.assignOutputRDDStats(inst, output, input1, input2);
            output.rddStats.cost = loadTime + SparkCostUtils.getMatMulInstTime(binst, input1, input2, output, this.driverMetrics, this.executorMetrics);
        } else if (inst instanceof MapmmChainSPInstruction) {
            MapmmChainSPInstruction mmchaininst = (MapmmChainSPInstruction)inst;
            VarStats input1 = this.getStats(mmchaininst.input1.getName());
            VarStats input2 = this.getStats(mmchaininst.input1.getName());
            VarStats input3 = null;
            double loadTime = this.loadRDDStatsAndEstimateTime(input1) + this.loadBroadcastVarStatsAndEstimateTime(input2);
            if (mmchaininst.input3 != null) {
                input3 = this.getStats(mmchaininst.input3.getName());
                loadTime += this.loadBroadcastVarStatsAndEstimateTime(input3);
            }
            output = this.getStats(mmchaininst.output.getName());
            SparkCostUtils.assignOutputRDDStats(inst, output, input1, input2, input3);
            output.rddStats.cost = loadTime + SparkCostUtils.getMatMulChainInstTime(mmchaininst, input1, input2, input3, output, this.driverMetrics, this.executorMetrics);
        } else if (inst instanceof CtableSPInstruction) {
            CtableSPInstruction tableInst = (CtableSPInstruction)inst;
            VarStats input1 = this.getStatsWithDefaultScalar(tableInst.input1.getName());
            VarStats input2 = this.getStatsWithDefaultScalar(tableInst.input2.getName());
            VarStats input3 = this.getStatsWithDefaultScalar(tableInst.input3.getName());
            double loadTime = this.loadRDDStatsAndEstimateTime(input1) + this.loadRDDStatsAndEstimateTime(input2) + this.loadRDDStatsAndEstimateTime(input3);
            output = this.getStats(tableInst.getOutputVariableName());
            VarStats outDim1 = this.getCTableDim(tableInst.getOutDim1());
            VarStats outDim2 = this.getCTableDim(tableInst.getOutDim2());
            SparkCostUtils.assignOutputRDDStats(inst, output, input1, input2, outDim1, outDim2);
            output.rddStats.cost = loadTime + SparkCostUtils.getCtableInstTime(tableInst, input1, input2, input3, output, this.executorMetrics);
        } else if (inst instanceof ParameterizedBuiltinSPInstruction) {
            ParameterizedBuiltinSPInstruction paramInst = (ParameterizedBuiltinSPInstruction)inst;
            VarStats input1 = this.getParameterizedBuiltinParamStats("target", paramInst.getParameterMap(), true);
            double loadTime = input1 != null ? this.loadRDDStatsAndEstimateTime(input1) : 0.0;
            VarStats input2 = null;
            switch (inst.getOpcode()) {
                case "rmempty": {
                    input2 = this.getParameterizedBuiltinParamStats("offset", paramInst.getParameterMap(), false);
                    if (Boolean.parseBoolean(paramInst.getParameterMap().get("bRmEmptyBC"))) {
                        loadTime += input2 != null ? this.loadBroadcastVarStatsAndEstimateTime(input2) : 0.0;
                        break;
                    }
                    loadTime += input2 != null ? this.loadRDDStatsAndEstimateTime(input2) : 0.0;
                    break;
                }
                case "contains": {
                    input2 = this.getParameterizedBuiltinParamStats("pattern", paramInst.getParameterMap(), false);
                    break;
                }
                case "groupedagg": {
                    input2 = this.getParameterizedBuiltinParamStats("groups", paramInst.getParameterMap(), false);
                }
            }
            output = this.getStatsWithDefaultScalar(paramInst.getOutputVariableName());
            SparkCostUtils.assignOutputRDDStats(inst, output, input1);
            output.rddStats.cost = loadTime + SparkCostUtils.getParameterizedBuiltinInstTime(paramInst, input1, input2, output, this.driverMetrics, this.executorMetrics);
        } else if (inst instanceof TernarySPInstruction) {
            TernarySPInstruction tInst = (TernarySPInstruction)inst;
            VarStats input1 = this.getStatsWithDefaultScalar(tInst.input1.getName());
            VarStats input2 = this.getStatsWithDefaultScalar(tInst.input2.getName());
            VarStats input3 = this.getStatsWithDefaultScalar(tInst.input3.getName());
            double loadTime = this.loadRDDStatsAndEstimateTime(input1) + this.loadRDDStatsAndEstimateTime(input2) + this.loadRDDStatsAndEstimateTime(input3);
            output = this.getStats(tInst.getOutputVariableName());
            SparkCostUtils.assignOutputRDDStats(inst, output, input1, input2, input3);
            output.rddStats.cost = loadTime + SparkCostUtils.getTernaryInstTime(tInst, input1, input2, input3, output, this.executorMetrics);
        } else if (inst instanceof QuaternarySPInstruction) {
            QuaternarySPInstruction quatInst = (QuaternarySPInstruction)inst;
            VarStats input1 = this.getStats(quatInst.input1.getName());
            VarStats input2 = this.getStats(quatInst.input2.getName());
            VarStats input3 = this.getStats(quatInst.input3.getName());
            double loadTime = this.loadRDDStatsAndEstimateTime(input1) + this.loadBroadcastVarStatsAndEstimateTime(input2) + this.loadBroadcastVarStatsAndEstimateTime(input3);
            output = this.getStatsWithDefaultScalar(quatInst.getOutputVariableName());
            SparkCostUtils.assignOutputRDDStats(inst, output, input1, input2, input3);
            output.rddStats.cost = loadTime + SparkCostUtils.getQuaternaryInstTime(quatInst, input1, input2, input3, output, this.driverMetrics, this.executorMetrics);
        } else {
            if (!(inst instanceof WriteSPInstruction)) throw new RuntimeException("Unsupported instruction: " + inst.getOpcode());
            WriteSPInstruction wInst = (WriteSPInstruction)inst;
            VarStats input = this.getStats(wInst.input1.getName());
            double loadTime = this.loadRDDStatsAndEstimateTime(input);
            String fileName = wInst.getInput2().isLiteral() ? wInst.getInput2().getLiteral().getStringValue() : "hdfs_file";
            String dataSource = IOCostUtils.getDataSource(fileName);
            String formatString = wInst.getInput3().isLiteral() ? wInst.getInput3().getLiteral().getStringValue() : "text";
            input.fileInfo = new Object[]{dataSource, Types.FileFormat.safeValueOf(formatString)};
            return loadTime + IOCostUtils.getHadoopWriteTime(input, this.executorMetrics);
        }
        if (!output.rddStats.isCollected) return 0.0;
        if (!output.isScalar()) {
            output.allocatedMemory = OptimizerUtils.estimateSizeExactSparsity(output.characteristics);
            this.putInMemory(output);
        }
        double ret = output.rddStats.cost;
        output.rddStats = null;
        return ret;
    }

    public double getTimeEstimateSparkJob(VarStats varToCollect) {
        double collectTime;
        if (varToCollect.rddStats == null) {
            throw new RuntimeException("Missing RDD statistics for estimating execution time for Spark Job");
        }
        double computeTime = varToCollect.rddStats.cost;
        if (OptimizerUtils.checkSparkCollectMemoryBudget(varToCollect.characteristics, this.freeLocalMemory, false)) {
            collectTime = IOCostUtils.getSparkCollectTime(varToCollect.rddStats, this.driverMetrics, this.executorMetrics);
        } else {
            varToCollect.fileInfo = new Object[]{"hdfs", Types.FileFormat.BINARY};
            collectTime = IOCostUtils.getHadoopWriteTime(varToCollect, this.executorMetrics) + IOCostUtils.getFileSystemReadTime(varToCollect, this.driverMetrics);
        }
        if (varToCollect.rddStats.checkpoint) {
            varToCollect.rddStats.cost = 0.0;
        } else {
            varToCollect.rddStats = null;
        }
        if (computeTime < 0.0 || collectTime < 0.0) {
            throw new RuntimeException("Unexpected negative value at estimating Spark Job execution time");
        }
        if (computeTime == Double.POSITIVE_INFINITY || collectTime == Double.POSITIVE_INFINITY) {
            throw new RuntimeException("Unexpected infinity value at estimating Spark Job execution time");
        }
        return collectTime + computeTime;
    }

    private double loadCPVarStatsAndEstimateTime(VarStats input) throws CostEstimationException {
        double loadTime;
        if (input.isScalar() || input.allocatedMemory > 0L) {
            return 0.0;
        }
        if (input.rddStats != null && (input.fileInfo == null && !input.rddStats.checkpoint || input.fileInfo != null && input.rddStats.checkpoint)) {
            loadTime = this.getTimeEstimateSparkJob(input);
        } else {
            if (input.fileInfo == null || input.fileInfo.length != 2) {
                throw new RuntimeException("Time estimation is not possible without file info.");
            }
            if (IOCostUtils.isInvalidDataSource((String)input.fileInfo[0])) {
                throw new RuntimeException("Time estimation is not possible for data source: " + input.fileInfo[0]);
            }
            loadTime = IOCostUtils.getFileSystemReadTime(input, this.driverMetrics);
        }
        input.allocatedMemory = OptimizerUtils.estimateSizeExactSparsity(input.characteristics);
        this.putInMemory(input);
        return loadTime;
    }

    private double loadBroadcastVarStatsAndEstimateTime(VarStats input) throws CostEstimationException {
        double time = this.loadCPVarStatsAndEstimateTime(input);
        if (this.freeLocalMemory - input.allocatedMemory < 0L) {
            throw new CostEstimationException("Insufficient local memory for broadcasting");
        }
        return time;
    }

    private void putInMemory(VarStats output) throws CostEstimationException {
        if (output.isScalar() || output.allocatedMemory <= 0x100000L) {
            return;
        }
        if (this.freeLocalMemory - output.allocatedMemory < 0L) {
            throw new CostEstimationException("Insufficient local memory");
        }
        this.freeLocalMemory -= output.allocatedMemory;
    }

    private void removeFromMemory(VarStats input) {
        if (input == null) {
            return;
        }
        if (!input.isScalar() && input.allocatedMemory > 0x100000L) {
            this.freeLocalMemory += input.allocatedMemory;
            if (this.freeLocalMemory > this.localMemoryLimit) {
                throw new RuntimeException("Unexpectedly large amount of freed CP memory");
            }
        }
        if (input.rddStats != null) {
            input.rddStats = null;
        }
        input.allocatedMemory = -1L;
    }

    private double loadRDDStatsAndEstimateTime(VarStats input) {
        double ret;
        if (input.isScalar()) {
            return 0.0;
        }
        if (input.rddStats == null) {
            RDDStats inputRDD = input.rddStats = new RDDStats(input);
            if (input.allocatedMemory >= 0L) {
                if (inputRDD.distributedSize < this.freeLocalMemory && (double)inputRDD.distributedSize < 0.1 * (double)this.localMemoryLimit) {
                    input.fileInfo = new Object[]{"hdfs", Types.FileFormat.BINARY};
                    ret = IOCostUtils.getFileSystemWriteTime(input, this.driverMetrics);
                    ret += IOCostUtils.getHadoopReadTime(input, this.executorMetrics);
                } else {
                    ret = IOCostUtils.getSparkParallelizeTime(inputRDD, this.driverMetrics, this.executorMetrics);
                }
            } else {
                if (input.fileInfo == null || input.fileInfo.length != 2) {
                    throw new RuntimeException("File info missing for a file to be read on Spark.");
                }
                ret = IOCostUtils.getHadoopReadTime(input, this.executorMetrics);
            }
        } else if (input.rddStats.distributedSize > 0L) {
            ret = input.rddStats.cost;
            input.rddStats.cost = 0.0;
        } else {
            throw new RuntimeException("Initialized RDD stats without initialized data characteristics is undefined behaviour");
        }
        return ret;
    }

    private VarStats getCTableDim(CPOperand dimOperand) {
        VarStats dimStats = dimOperand.isLiteral() ? new VarStats(dimOperand.getLiteral().toString(), null) : this.getStatsWithDefaultScalar(dimOperand.getName());
        return dimStats;
    }

    private VarStats getParameterizedBuiltinParamStats(String key, HashMap<String, String> params, boolean required) {
        String varName = params.get(key);
        if (required && varName == null) {
            throw new RuntimeException("ParameterizedBuiltin operation is missing required parameter object for key " + key);
        }
        if (varName == null) {
            return null;
        }
        return this.getStatsWithDefaultScalar(varName);
    }
}

