/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.utils.stats;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class NGramBuilder<T, U> {
    private final T[] currentNGram;
    private final U[] currentStats;
    private int currentIndex = 0;
    private int currentSize = 0;
    private final Function<T, String> idGenerator;
    private final BiFunction<U, U, U> statsMerger;
    private final ConcurrentHashMap<String, NGramEntry<T, U>> nGrams;

    public static <T, U> String toCSV(String[] columnNames, List<NGramEntry<T, U>> entries, Function<NGramEntry<T, U>, String> statsMapper) {
        StringBuilder builder = new StringBuilder(String.join((CharSequence)",", columnNames));
        builder.append("\n");
        for (NGramEntry<T, U> entry : entries) {
            builder.append(entry.getIdentifier().replace(",", ";"));
            builder.append(",");
            builder.append(entry.getCumStats());
            builder.append(",");
            if (statsMapper != null) {
                builder.append(statsMapper.apply(entry));
                builder.append(",");
            }
            builder.append(entry.getOccurrences());
            builder.append("\n");
        }
        return builder.toString();
    }

    public static <T, U> void toCSVStream(String[] columnNames, List<NGramEntry<T, U>> entries, Function<NGramEntry<T, U>, String> statsMapper, Consumer<String> lineConsumer) {
        StringBuilder builder = new StringBuilder(String.join((CharSequence)",", columnNames));
        builder.append("\n");
        lineConsumer.accept(builder.toString());
        builder.setLength(0);
        for (NGramEntry<T, U> entry : entries) {
            builder.append(entry.getIdentifier().replace(",", ";"));
            builder.append(",");
            builder.append(entry.getCumStats());
            builder.append(",");
            if (statsMapper != null) {
                builder.append(statsMapper.apply(entry));
                builder.append(",");
            }
            builder.append(entry.getOccurrences());
            builder.append("\n");
            lineConsumer.accept(builder.toString());
            builder.setLength(0);
        }
    }

    public NGramBuilder(Class<T> clazz, Class<U> clazz2, int size, Function<T, String> idGenerator, BiFunction<U, U, U> statsMerger) {
        this.currentNGram = (Object[])Array.newInstance(clazz, size);
        this.currentStats = (Object[])Array.newInstance(clazz2, size);
        this.idGenerator = idGenerator;
        this.nGrams = new ConcurrentHashMap();
        this.statsMerger = statsMerger;
    }

    public int getSize() {
        return this.currentNGram.length;
    }

    public synchronized void merge(NGramBuilder<T, U> builder) {
        builder.nGrams.forEach((k, v) -> this.nGrams.merge((String)k, (NGramEntry<T, U>)v, (v1, v2) -> {
            v1.add(v2.occurrences);
            v1.setCumStats(this.statsMerger.apply(v1.getCumStats(), v2.getCumStats()));
            int index1 = v1.offset;
            int index2 = v2.offset;
            U[] stats1 = v1.getStats();
            U[] stats2 = v2.getStats();
            for (int i = 0; i < stats1.length; ++i) {
                stats1[index1] = this.statsMerger.apply(stats1[index1], stats2[index2]);
                index1 = (index1 + 1) % stats1.length;
                index2 = (index2 + 1) % stats2.length;
            }
            return v1;
        }));
    }

    public synchronized void append(T element, U stat) {
        this.currentNGram[this.currentIndex] = element;
        this.currentStats[this.currentIndex] = stat;
        this.currentIndex = (this.currentIndex + 1) % this.currentNGram.length;
        if (this.currentSize < this.currentNGram.length) {
            ++this.currentSize;
        }
        if (this.currentSize == this.currentNGram.length) {
            StringBuilder builder = new StringBuilder(this.currentNGram.length);
            builder.append("(");
            for (int i = 0; i < this.currentNGram.length; ++i) {
                int actualIndex = (i + this.currentIndex) % this.currentSize;
                builder.append(this.idGenerator.apply(this.currentNGram[actualIndex]));
                if (i == this.currentNGram.length - 1) continue;
                builder.append(", ");
            }
            builder.append(")");
            this.registerElement(builder.toString(), stat);
        }
    }

    public synchronized List<NGramEntry<T, U>> getTopK(int k) {
        return this.nGrams.entrySet().stream().sorted(Comparator.comparingLong(v -> ((NGramEntry)v.getValue()).occurrences).reversed()).map(Map.Entry::getValue).limit(k).collect(Collectors.toList());
    }

    public synchronized List<NGramEntry<T, U>> getTopK(int k, Comparator<NGramEntry<T, U>> comparator, boolean reversed) {
        return this.nGrams.entrySet().stream().sorted((e1, e2) -> reversed ? comparator.compare((NGramEntry)e2.getValue(), (NGramEntry)e1.getValue()) : comparator.compare((NGramEntry)e1.getValue(), (NGramEntry)e2.getValue())).map(Map.Entry::getValue).limit(k).collect(Collectors.toList());
    }

    public synchronized void clearCurrentRecording() {
        this.currentIndex = 0;
        this.currentSize = 0;
    }

    private synchronized void registerElement(String id, U stat) {
        this.nGrams.compute(id, (key, entry) -> {
            if (entry == null) {
                U cumStat = this.currentStats[0];
                for (int i = 1; i < this.currentStats.length; ++i) {
                    cumStat = this.statsMerger.apply(this.currentStats[i], cumStat);
                }
                entry = new NGramEntry<T, Object>(id, Arrays.copyOf(this.currentNGram, this.currentNGram.length), Arrays.copyOf(this.currentStats, this.currentStats.length), cumStat, this.currentIndex);
            } else {
                entry.increment();
                U[] stats = entry.getStats();
                Object cumStat = null;
                int mCurrentIndex = this.currentIndex;
                int mIndexEntry = entry.offset;
                for (int i = 0; i < stats.length; ++i) {
                    stats[mIndexEntry] = this.statsMerger.apply(stats[mIndexEntry], this.currentStats[mCurrentIndex]);
                    cumStat = i == 0 ? (Object)stats[mIndexEntry] : (Object)this.statsMerger.apply(stats[mIndexEntry], cumStat);
                    mCurrentIndex = (mCurrentIndex + 1) % stats.length;
                    mIndexEntry = (mIndexEntry + 1) % stats.length;
                }
                entry.setCumStats(cumStat);
            }
            return entry;
        });
    }

    public static class NGramEntry<T, U> {
        private final String identifier;
        private final T[] entry;
        private U[] stats;
        private U cumStats;
        private long occurrences;
        private int offset;

        public NGramEntry(String identifier, T[] entry, U[] stats, U cumStats, int offset) {
            this.identifier = identifier;
            this.entry = entry;
            this.stats = stats;
            this.occurrences = 1L;
            this.offset = offset;
            this.cumStats = cumStats;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public long getOccurrences() {
            return this.occurrences;
        }

        public U getStat(int index) {
            if (index < 0 || index >= this.entry.length) {
                throw new ArrayIndexOutOfBoundsException("Index " + index + " is out of bounds");
            }
            index = (index + this.offset) % this.entry.length;
            return this.stats[index];
        }

        public U getCumStats() {
            return this.cumStats;
        }

        public U[] getStats() {
            return this.stats;
        }

        public int getOffset() {
            return this.offset;
        }

        void setCumStats(U cumStats) {
            this.cumStats = cumStats;
        }

        public T get(int index) {
            if (index < 0 || index >= this.entry.length) {
                throw new ArrayIndexOutOfBoundsException("Index " + index + " is out of bounds");
            }
            index = (index + this.offset) % this.entry.length;
            return this.entry[index];
        }

        private NGramEntry<T, U> increment() {
            ++this.occurrences;
            return this;
        }

        private NGramEntry<T, U> add(NGramEntry<T, U> entry) {
            return this.add(entry.occurrences);
        }

        private NGramEntry<T, U> add(long n) {
            this.occurrences += n;
            return this;
        }
    }
}

