/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy;

import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import org.apache.curator.framework.CuratorFramework;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.deploy.FaultToleranceTest$delayedInit$body;
import org.apache.spark.deploy.SparkCuratorUtil$;
import org.apache.spark.deploy.SparkDocker$;
import org.apache.spark.deploy.TestMasterInfo;
import org.apache.spark.deploy.TestWorkerInfo;
import org.apache.spark.deploy.master.RecoveryState$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.Deploy$;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.App;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.generic.TraversableForwarder;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class FaultToleranceTest$
implements App,
Logging {
    public static FaultToleranceTest$ MODULE$;
    private SparkConf conf;
    private String zkDir;
    private ListBuffer<TestMasterInfo> masters;
    private ListBuffer<TestWorkerInfo> workers;
    private SparkContext sc;
    private CuratorFramework zk;
    private int numPassed;
    private int numFailed;
    private String sparkHome;
    private String containerSparkHome;
    private String dockerMountDir;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private final long executionStart;
    private String[] scala$App$$_args;
    private final ListBuffer<Function0<BoxedUnit>> scala$App$$initCode;

    static {
        new FaultToleranceTest$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public String[] args() {
        return App.args$((App)this);
    }

    public void delayedInit(Function0<BoxedUnit> body2) {
        App.delayedInit$((App)this, body2);
    }

    public void main(String[] args) {
        App.main$((App)this, (String[])args);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public long executionStart() {
        return this.executionStart;
    }

    public String[] scala$App$$_args() {
        return this.scala$App$$_args;
    }

    public void scala$App$$_args_$eq(String[] x$1) {
        this.scala$App$$_args = x$1;
    }

    public ListBuffer<Function0<BoxedUnit>> scala$App$$initCode() {
        return this.scala$App$$initCode;
    }

    public void scala$App$_setter_$executionStart_$eq(long x$1) {
        this.executionStart = x$1;
    }

    public final void scala$App$_setter_$scala$App$$initCode_$eq(ListBuffer<Function0<BoxedUnit>> x$1) {
        this.scala$App$$initCode = x$1;
    }

    private SparkConf conf() {
        return this.conf;
    }

    private String zkDir() {
        return this.zkDir;
    }

    private ListBuffer<TestMasterInfo> masters() {
        return this.masters;
    }

    private ListBuffer<TestWorkerInfo> workers() {
        return this.workers;
    }

    private SparkContext sc() {
        return this.sc;
    }

    private void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    private CuratorFramework zk() {
        return this.zk;
    }

    private int numPassed() {
        return this.numPassed;
    }

    private void numPassed_$eq(int x$1) {
        this.numPassed = x$1;
    }

    private int numFailed() {
        return this.numFailed;
    }

    private void numFailed_$eq(int x$1) {
        this.numFailed = x$1;
    }

    private String sparkHome() {
        return this.sparkHome;
    }

    private String containerSparkHome() {
        return this.containerSparkHome;
    }

    private String dockerMountDir() {
        return this.dockerMountDir;
    }

    private void afterEach() {
        if (this.sc() != null) {
            this.sc().stop();
            this.sc_$eq(null);
        }
        this.terminateCluster();
        SparkCuratorUtil$.MODULE$.deleteRecursive(this.zk(), new StringBuilder(13).append(this.zkDir()).append("/spark_leader").toString());
        SparkCuratorUtil$.MODULE$.deleteRecursive(this.zk(), new StringBuilder(14).append(this.zkDir()).append("/master_status").toString());
    }

    private void test(String name, Function0<BoxedUnit> fn) {
        try {
            fn.apply$mcV$sp();
            this.numPassed_$eq(this.numPassed() + 1);
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "==============================================");
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(8).append("Passed: ").append(name).toString());
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "==============================================");
        }
        catch (Exception e) {
            this.numFailed_$eq(this.numFailed() + 1);
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(8).append("FAILED: ").append(name).toString(), e);
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            throw scala.sys.package$.MODULE$.exit(1);
        }
        this.afterEach();
    }

    private void addMasters(int num) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append(">>>>> ADD MASTERS ").append(num).append(" <<<<<").toString());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), num).foreach((Function1 & Serializable & scala.Serializable)x$3 -> FaultToleranceTest$.$anonfun$addMasters$2(BoxesRunTime.unboxToInt((Object)x$3)));
    }

    private void addWorkers(int num) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append(">>>>> ADD WORKERS ").append(num).append(" <<<<<").toString());
        String masterUrls = this.getMasterUrls((Seq<TestMasterInfo>)this.masters().toSeq());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), num).foreach((Function1 & Serializable & scala.Serializable)x$4 -> FaultToleranceTest$.$anonfun$addWorkers$2(masterUrls, BoxesRunTime.unboxToInt((Object)x$4)));
    }

    private void createClient() {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> ">>>>> CREATE CLIENT <<<<<");
        if (this.sc() != null) {
            this.sc().stop();
        }
        System.setProperty(org.apache.spark.internal.config.package$.MODULE$.DRIVER_PORT().key(), "0");
        this.sc_$eq(new SparkContext(this.getMasterUrls((Seq<TestMasterInfo>)this.masters().toSeq()), "fault-tolerance", this.containerSparkHome()));
    }

    private String getMasterUrls(Seq<TestMasterInfo> masters) {
        return new StringBuilder(8).append("spark://").append(((TraversableOnce)masters.map((Function1 & Serializable & scala.Serializable)master -> new StringBuilder(5).append(master.ip()).append(":7077").toString(), Seq$.MODULE$.canBuildFrom())).mkString(",")).toString();
    }

    private TestMasterInfo getLeader() {
        ListBuffer leaders = (ListBuffer)this.masters().filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)FaultToleranceTest$.$anonfun$getLeader$1(x$5)));
        this.assertTrue(leaders.size() == 1, this.assertTrue$default$2());
        return (TestMasterInfo)leaders.apply(0);
    }

    private void killLeader() {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> ">>>>> KILL LEADER <<<<<");
        this.masters().foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
            x$6.readState();
            return BoxedUnit.UNIT;
        });
        TestMasterInfo leader = this.getLeader();
        this.masters().$minus$eq((Object)leader);
        leader.kill();
    }

    private void delay(Duration secs) {
        Thread.sleep(secs.toMillis());
    }

    private Duration delay$default$1() {
        return new package.DurationInt(package$.MODULE$.DurationInt(5)).seconds();
    }

    private void terminateCluster() {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> ">>>>> TERMINATE CLUSTER <<<<<");
        this.masters().foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
            x$7.kill();
            return BoxedUnit.UNIT;
        });
        this.workers().foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
            x$8.kill();
            return BoxedUnit.UNIT;
        });
        this.masters().clear();
        this.workers().clear();
    }

    private void assertUsable() {
        Future f = Future$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            boolean bl;
            try {
                SparkContext qual$1 = MODULE$.sc();
                Range x$1 = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10);
                int x$2 = qual$1.parallelize$default$2();
                int[] res = (int[])qual$1.parallelize(x$1, x$2, ClassTag$.MODULE$.Int()).collect();
                List list = new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(res)).toList();
                List list2 = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).toList();
                MODULE$.assertTrue(!(list != null ? !list.equals(list2) : list2 != null), MODULE$.assertTrue$default$2());
                bl = true;
            }
            catch (Exception e) {
                MODULE$.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "assertUsable() had exception", e);
                e.printStackTrace();
                bl = false;
            }
            return bl;
        }, ExecutionContext.Implicits$.MODULE$.global());
        this.assertTrue(BoxesRunTime.unboxToBoolean(ThreadUtils$.MODULE$.awaitResult(f, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(2)).minutes())), this.assertTrue$default$2());
    }

    private void assertValidClusterState() {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> ">>>>> ASSERT VALID CLUSTER STATE <<<<<");
        this.assertUsable();
        IntRef numAlive = IntRef.create((int)0);
        IntRef numStandby = IntRef.create((int)0);
        IntRef numLiveApps = IntRef.create((int)0);
        ObjectRef liveWorkerIPs = ObjectRef.create((Object)Nil$.MODULE$);
        Future f = Future$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            boolean bl;
            try {
                while (!this.stateValid$1(liveWorkerIPs, numAlive, numStandby, numLiveApps)) {
                    Thread.sleep(1000L);
                    numAlive$1.elem = 0;
                    numStandby$1.elem = 0;
                    numLiveApps$1.elem = 0;
                    MODULE$.masters().foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
                        x$10.readState();
                        return BoxedUnit.UNIT;
                    });
                    MODULE$.masters().foreach((Function1 & Serializable & scala.Serializable)master -> {
                        FaultToleranceTest$.$anonfun$assertValidClusterState$6(numAlive, liveWorkerIPs, numStandby, numLiveApps, master);
                        return BoxedUnit.UNIT;
                    });
                }
                bl = true;
            }
            catch (Exception e) {
                MODULE$.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "assertValidClusterState() had exception", e);
                bl = false;
            }
            return bl;
        }, ExecutionContext.Implicits$.MODULE$.global());
        try {
            this.assertTrue(BoxesRunTime.unboxToBoolean(ThreadUtils$.MODULE$.awaitResult(f, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(2)).minutes())), this.assertTrue$default$2());
        }
        catch (TimeoutException e) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("Master states: ").append(MODULE$.masters().map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.state(), ListBuffer$.MODULE$.canBuildFrom())).toString());
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(10).append("Num apps: ").append(numLiveApps$1.elem).toString());
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("IPs expected: ").append(MODULE$.workers().map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.ip(), ListBuffer$.MODULE$.canBuildFrom())).append(" / found: ").append((Seq)liveWorkerIPs$1.elem).toString());
            throw new RuntimeException("Failed to get into acceptable cluster state after 2 min.", e);
        }
    }

    private void assertTrue(boolean bool, String message) {
        if (!bool) {
            throw new IllegalStateException(new StringBuilder(18).append("Assertion failed: ").append(message).toString());
        }
    }

    private String assertTrue$default$2() {
        return "";
    }

    public static final /* synthetic */ ListBuffer $anonfun$addMasters$2(int x$3) {
        return MODULE$.masters().$plus$eq((Object)SparkDocker$.MODULE$.startMaster(MODULE$.dockerMountDir()));
    }

    public static final /* synthetic */ ListBuffer $anonfun$addWorkers$2(String masterUrls$1, int x$4) {
        return MODULE$.workers().$plus$eq((Object)SparkDocker$.MODULE$.startWorker(MODULE$.dockerMountDir(), masterUrls$1));
    }

    public static final /* synthetic */ boolean $anonfun$getLeader$1(TestMasterInfo x$5) {
        Enumeration.Value value = x$5.state();
        Enumeration.Value value2 = RecoveryState$.MODULE$.ALIVE();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    private final boolean stateValid$1(ObjectRef liveWorkerIPs$1, IntRef numAlive$1, IntRef numStandby$1, IntRef numLiveApps$1) {
        Seq seq = (Seq)liveWorkerIPs$1.elem;
        return ((TraversableForwarder)this.workers().map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.ip(), ListBuffer$.MODULE$.canBuildFrom())).forall((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)seq.contains(elem))) && numAlive$1.elem == 1 && numStandby$1.elem == this.masters().size() - 1 && numLiveApps$1.elem >= 1;
    }

    public static final /* synthetic */ void $anonfun$assertValidClusterState$6(IntRef numAlive$1, ObjectRef liveWorkerIPs$1, IntRef numStandby$1, IntRef numLiveApps$1, TestMasterInfo master) {
        Enumeration.Value value = master.state();
        Enumeration.Value value2 = RecoveryState$.MODULE$.ALIVE();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            ++numAlive$1.elem;
            liveWorkerIPs$1.elem = master.liveWorkerIPs();
        } else {
            Enumeration.Value value4 = RecoveryState$.MODULE$.STANDBY();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                ++numStandby$1.elem;
            }
        }
        numLiveApps$1.elem += master.numLiveApps();
    }

    public final void delayedEndpoint$org$apache$spark$deploy$FaultToleranceTest$1() {
        this.conf = new SparkConf();
        this.zkDir = (String)((Option)this.conf().get(Deploy$.MODULE$.ZOOKEEPER_DIRECTORY())).getOrElse((Function0 & Serializable & scala.Serializable)() -> "/spark");
        this.masters = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.workers = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.zk = SparkCuratorUtil$.MODULE$.newClient(this.conf(), SparkCuratorUtil$.MODULE$.newClient$default$2());
        this.numPassed = 0;
        this.numFailed = 0;
        this.sparkHome = System.getenv("SPARK_HOME");
        this.assertTrue(this.sparkHome() != null, "Run with a valid SPARK_HOME");
        this.containerSparkHome = "/opt/spark";
        this.dockerMountDir = new StringOps(Predef$.MODULE$.augmentString("%s:%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.sparkHome(), this.containerSparkHome()}));
        System.setProperty(org.apache.spark.internal.config.package$.MODULE$.DRIVER_HOST_ADDRESS().key(), "172.17.42.1");
        this.test("sanity-basic", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            MODULE$.addMasters(1);
            MODULE$.addWorkers(1);
            MODULE$.createClient();
            MODULE$.assertValidClusterState();
        });
        this.test("sanity-many-masters", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            MODULE$.addMasters(3);
            MODULE$.addWorkers(3);
            MODULE$.createClient();
            MODULE$.assertValidClusterState();
        });
        this.test("single-master-halt", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            MODULE$.addMasters(3);
            MODULE$.addWorkers(2);
            MODULE$.createClient();
            MODULE$.assertValidClusterState();
            MODULE$.killLeader();
            MODULE$.delay((Duration)new package.DurationInt(package$.MODULE$.DurationInt(30)).seconds());
            MODULE$.assertValidClusterState();
            MODULE$.createClient();
            MODULE$.assertValidClusterState();
        });
        this.test("single-master-restart", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            MODULE$.addMasters(1);
            MODULE$.addWorkers(2);
            MODULE$.createClient();
            MODULE$.assertValidClusterState();
            MODULE$.killLeader();
            MODULE$.addMasters(1);
            MODULE$.delay((Duration)new package.DurationInt(package$.MODULE$.DurationInt(30)).seconds());
            MODULE$.assertValidClusterState();
            MODULE$.killLeader();
            MODULE$.addMasters(1);
            MODULE$.delay((Duration)new package.DurationInt(package$.MODULE$.DurationInt(30)).seconds());
            MODULE$.assertValidClusterState();
        });
        this.test("cluster-failure", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            MODULE$.addMasters(2);
            MODULE$.addWorkers(2);
            MODULE$.createClient();
            MODULE$.assertValidClusterState();
            MODULE$.terminateCluster();
            MODULE$.addMasters(2);
            MODULE$.addWorkers(2);
            MODULE$.assertValidClusterState();
        });
        this.test("all-but-standby-failure", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            MODULE$.addMasters(2);
            MODULE$.addWorkers(2);
            MODULE$.createClient();
            MODULE$.assertValidClusterState();
            MODULE$.killLeader();
            MODULE$.workers().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                x$1.kill();
                return BoxedUnit.UNIT;
            });
            MODULE$.workers().clear();
            MODULE$.delay((Duration)new package.DurationInt(package$.MODULE$.DurationInt(30)).seconds());
            MODULE$.addWorkers(2);
            MODULE$.assertValidClusterState();
        });
        this.test("rolling-outage", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            MODULE$.addMasters(1);
            MODULE$.delay(MODULE$.delay$default$1());
            MODULE$.addMasters(1);
            MODULE$.delay(MODULE$.delay$default$1());
            MODULE$.addMasters(1);
            MODULE$.addWorkers(2);
            MODULE$.createClient();
            MODULE$.assertValidClusterState();
            TestMasterInfo testMasterInfo = MODULE$.getLeader();
            Object object = MODULE$.masters().head();
            MODULE$.assertTrue(!(testMasterInfo != null ? !testMasterInfo.equals(object) : object != null), MODULE$.assertTrue$default$2());
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 3).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$2 -> {
                MODULE$.killLeader();
                MODULE$.delay((Duration)new package.DurationInt(package$.MODULE$.DurationInt(30)).seconds());
                MODULE$.assertValidClusterState();
                TestMasterInfo testMasterInfo = MODULE$.getLeader();
                Object object = MODULE$.masters().head();
                MODULE$.assertTrue(!(testMasterInfo != null ? !testMasterInfo.equals(object) : object != null), MODULE$.assertTrue$default$2());
                MODULE$.addMasters(1);
            });
        });
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Ran %s tests, %s passed and %s failed")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(MODULE$.numPassed() + MODULE$.numFailed())), BoxesRunTime.boxToInteger((int)MODULE$.numPassed()), BoxesRunTime.boxToInteger((int)MODULE$.numFailed())})));
    }

    private FaultToleranceTest$() {
        MODULE$ = this;
        App.$init$((App)this);
        Logging.$init$((Logging)this);
        this.delayedInit((Function0<BoxedUnit>)new FaultToleranceTest$delayedInit$body(this));
    }
}

