/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.binary.types;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.DataType;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.SimpleTypeSerializer;

public class BigDecimalSerializer
extends SimpleTypeSerializer<BigDecimal> {
    public BigDecimalSerializer() {
        super(DataType.BIGDECIMAL);
    }

    @Override
    protected BigDecimal readValue(Buffer buffer, GraphBinaryReader context) throws IOException {
        int scale = context.readValue(buffer, Integer.class, false);
        BigInteger unscaled = context.readValue(buffer, BigInteger.class, false);
        return new BigDecimal(unscaled, scale);
    }

    @Override
    protected void writeValue(BigDecimal value, Buffer buffer, GraphBinaryWriter context) throws IOException {
        context.writeValue(value.scale(), buffer, false);
        context.writeValue(value.unscaledValue(), buffer, false);
    }
}

