/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.jsp.jstl.core;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.el.ELContext;
import javax.el.ValueExpression;

public final class IteratedExpression {
    protected final ValueExpression orig;
    protected final String delims;
    private Object originalListObject = null;
    private Iterator currentListObject = null;
    private int currentIndex = 0;
    private TypesEnum type = TypesEnum.Undefined;

    public IteratedExpression(ValueExpression orig, String delims) {
        this.orig = orig;
        this.delims = delims;
    }

    public Object getItem(ELContext context, int i) {
        if (this.originalListObject == null) {
            this.originalListObject = this.orig.getValue(context);
            if (this.originalListObject instanceof Collection) {
                this.type = TypesEnum.ACollection;
            } else if (this.originalListObject instanceof Iterator) {
                this.type = TypesEnum.AnIterator;
            } else if (this.originalListObject instanceof Enumeration) {
                this.type = TypesEnum.AnEnumeration;
            } else if (this.originalListObject instanceof Map) {
                this.type = TypesEnum.AMap;
            } else if (this.originalListObject instanceof String) {
                this.type = TypesEnum.AString;
            } else {
                throw new RuntimeException("IteratedExpression.getItem: Object not of correct type.");
            }
            this.currentListObject = this.returnNewIterator(this.originalListObject, this.type);
        }
        Object currentObject = null;
        if (i < this.currentIndex) {
            this.currentListObject = this.returnNewIterator(this.originalListObject, this.type);
            this.currentIndex = 0;
        }
        while (this.currentIndex <= i) {
            if (!this.currentListObject.hasNext()) {
                throw new RuntimeException("IteratedExpression.getItem: Index out of Bounds");
            }
            currentObject = this.currentListObject.next();
            ++this.currentIndex;
        }
        return currentObject;
    }

    public ValueExpression getValueExpression() {
        return this.orig;
    }

    private Iterator returnNewIterator(Object o, TypesEnum type) {
        Iterator<Object> i = null;
        switch (type) {
            case ACollection: {
                i = ((Collection)o).iterator();
                break;
            }
            case AnIterator: {
                if (this.currentListObject == null) {
                    Vector v = new Vector();
                    Iterator myI = (Iterator)o;
                    while (myI.hasNext()) {
                        v.add(myI.next());
                    }
                    this.originalListObject = v;
                }
                i = ((Vector)this.originalListObject).iterator();
                break;
            }
            case AnEnumeration: {
                if (this.currentListObject == null) {
                    Vector v = new Vector();
                    Enumeration myE = (Enumeration)o;
                    while (myE.hasMoreElements()) {
                        v.add(myE.nextElement());
                    }
                    this.originalListObject = v;
                }
                i = ((Vector)this.originalListObject).iterator();
                break;
            }
            case AMap: {
                Set s = ((Map)o).entrySet();
                i = s.iterator();
                break;
            }
            case AString: {
                if (this.currentListObject == null) {
                    Vector<Object> v = new Vector<Object>();
                    StringTokenizer st = new StringTokenizer((String)o, this.delims);
                    while (st.hasMoreElements()) {
                        v.add(st.nextElement());
                    }
                    this.originalListObject = v;
                }
                i = ((Vector)this.originalListObject).iterator();
                break;
            }
        }
        return i;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TypesEnum {
        Undefined,
        ACollection,
        AnIterator,
        AnEnumeration,
        AMap,
        AString;

    }
}

