/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.encryption.keys.content.derivedKey;

import org.apache.xml.security.encryption.keys.content.derivedKey.KDFParams;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.utils.ElementProxy;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class HKDFParamsImpl
extends ElementProxy
implements KDFParams {
    public HKDFParamsImpl(Document doc) {
        super(doc);
    }

    public HKDFParamsImpl(Element element, String baseURI) throws XMLSecurityException {
        super(element, baseURI);
    }

    public void setPRFAlgorithm(String hmacHashAlgorithm) {
        Element targetElement = XMLUtils.selectNode(this.getElement().getFirstChild(), this.getBaseNamespace(), "PRF", 0);
        if (hmacHashAlgorithm == null) {
            LOG.log(System.Logger.Level.DEBUG, "HMAC Hash Method is null!");
            if (targetElement != null) {
                LOG.log(System.Logger.Level.DEBUG, "HMAC Hash Method is null, removing PRF element");
                targetElement.getParentNode().removeChild(targetElement);
            }
            return;
        }
        if (targetElement == null) {
            targetElement = this.createElementForFamilyLocal(this.getBaseNamespace(), "PRF");
            this.appendSelf(targetElement);
        }
        targetElement.setAttributeNS(null, "Algorithm", hmacHashAlgorithm);
    }

    public String getPRFAlgorithm() {
        Element prfElement = XMLUtils.selectXenc11Node(this.getElement().getFirstChild(), "PRF", 0);
        if (prfElement != null) {
            return prfElement.getAttributeNS(null, "Algorithm");
        }
        return null;
    }

    public void setInfo(String info) {
        this.setLocalElementValue(info, "Info");
    }

    public String getInfo() {
        return this.getLocalElementValue("Info");
    }

    public void setKeyLength(Integer keyLength) {
        this.setLocalElementValue(keyLength != null ? keyLength.toString() : null, "KeyLength");
    }

    public Integer getKeyLength() {
        String keyLengthStr = this.getLocalElementValue("KeyLength");
        Integer keyLength = null;
        if (keyLengthStr != null) {
            try {
                keyLength = Integer.parseInt(keyLengthStr);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid key length: " + keyLengthStr);
            }
        }
        return keyLength;
    }

    public void setSalt(String salt) {
        this.setLocalElementValue(salt, "Salt");
    }

    public String getSalt() {
        return this.getLocalElementValue("Salt");
    }

    @Override
    public String getBaseLocalName() {
        return "HKDFParams";
    }

    @Override
    public String getBaseNamespace() {
        return "http://www.w3.org/2021/04/xmldsig-more#";
    }

    public void setLocalElementValue(String value, String elementName) {
        Element targetElement = XMLUtils.selectNode(this.getElement().getFirstChild(), this.getBaseNamespace(), elementName, 0);
        if (value == null) {
            LOG.log(System.Logger.Level.DEBUG, "Element value: [%s] is null!", elementName);
            if (targetElement != null) {
                LOG.log(System.Logger.Level.DEBUG, "Element value: [%s] is null. Remove element!", elementName);
                targetElement.getParentNode().removeChild(targetElement);
            }
            return;
        }
        if (targetElement == null) {
            targetElement = this.createElementForFamilyLocal(this.getBaseNamespace(), elementName);
            this.appendSelf(targetElement);
        }
        targetElement.setTextContent(value);
    }

    public String getLocalElementValue(String elementName) {
        Element targetElement = XMLUtils.selectNode(this.getElement().getFirstChild(), this.getBaseNamespace(), elementName, 0);
        if (targetElement != null) {
            return XMLUtils.getFullTextChildrenFromNode(targetElement);
        }
        return null;
    }
}

