/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util;

import jakarta.servlet.http.HttpServletResponse;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.turbine.Turbine;
import org.apache.turbine.pipeline.PipelineData;

public class HttpUtils {
    private static final String CHARACTERS_NOT_ALLOWED_IN_KEY = "[^\\w_/\\.-]";
    private static final Pattern CNAIK_PATTERN = Pattern.compile("[^\\w_/\\.-]");
    private static FastDateFormat httpDateFormat = FastDateFormat.getInstance((String)"EEE, dd MMM yyyy HH:mm:ss z", (TimeZone)TimeZone.getTimeZone("GMT"), (Locale)Locale.US);

    public static String formatHttpDate(Date date) {
        return httpDateFormat.format(date);
    }

    public static void setCacheHeaders(PipelineData pipelineData, int expiry) {
        HttpServletResponse response = pipelineData.get(Turbine.class, HttpServletResponse.class);
        if (0 == expiry) {
            response.setHeader("Pragma", "no-cache");
            response.setHeader("Cache-Control", "no-cache");
            response.setDateHeader("Expires", System.currentTimeMillis());
        } else {
            response.setDateHeader("Expires", System.currentTimeMillis() + (long)expiry);
        }
    }

    public static boolean keyRequiresClean(String parameter) {
        Matcher testMatcher = CNAIK_PATTERN.matcher(parameter);
        return testMatcher.find();
    }

    public static String getCleanedKey(String parameter) {
        return parameter.replaceAll(CHARACTERS_NOT_ALLOWED_IN_KEY, "");
    }
}

