/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.collections.prefixmap;

import java.io.Serializable;
import java.lang.reflect.Array;
import nl.basjes.collections.prefixmap.PrefixTrie;

class ASCIIPrefixTrie<V extends Serializable>
implements PrefixTrie<V> {
    private final boolean caseSensitive;
    private final int charIndex;
    private ASCIIPrefixTrie<V>[] childNodes;
    private V theValue;

    ASCIIPrefixTrie(boolean caseSensitive) {
        this(caseSensitive, 0);
    }

    ASCIIPrefixTrie(boolean caseSensitive, int charIndex) {
        this.caseSensitive = caseSensitive;
        this.charIndex = charIndex;
    }

    @Override
    public V add(String prefix, V value) {
        V previousValue = this.theValue;
        if (this.charIndex == prefix.length()) {
            this.theValue = value;
            return previousValue;
        }
        char myChar = prefix.charAt(this.charIndex);
        if (myChar < ' ' || myChar > '~') {
            throw new IllegalArgumentException("Only readable ASCII is allowed as prefix !!!");
        }
        if (this.childNodes == null) {
            this.childNodes = (ASCIIPrefixTrie[])Array.newInstance(ASCIIPrefixTrie.class, 128);
        }
        if (this.caseSensitive) {
            if (this.childNodes[myChar] == null) {
                this.childNodes[myChar] = new ASCIIPrefixTrie<V>(true, this.charIndex + 1);
            }
            previousValue = this.childNodes[myChar].add(prefix, value);
        } else {
            char lower = Character.toLowerCase(myChar);
            char upper = Character.toUpperCase(myChar);
            if (this.childNodes[lower] == null) {
                this.childNodes[lower] = new ASCIIPrefixTrie<V>(false, this.charIndex + 1);
            }
            previousValue = this.childNodes[lower].add(prefix, value);
            this.childNodes[upper] = this.childNodes[lower];
        }
        return previousValue;
    }

    @Override
    public V remove(String prefix) {
        ASCIIPrefixTrie<V> child;
        if (this.charIndex == prefix.length()) {
            V previousValue = this.theValue;
            this.theValue = null;
            return previousValue;
        }
        if (this.childNodes == null) {
            return null;
        }
        char myChar = prefix.charAt(this.charIndex);
        if (myChar < ' ' || myChar > '~') {
            throw new IllegalArgumentException("Only readable ASCII is allowed as prefix !!!");
        }
        if (!this.caseSensitive) {
            myChar = Character.toLowerCase(myChar);
        }
        if ((child = this.childNodes[myChar]) == null) {
            return null;
        }
        return child.remove(prefix);
    }

    @Override
    public boolean containsPrefix(String prefix) {
        return this.get(prefix) != null;
    }

    @Override
    public V get(String prefix) {
        if (this.charIndex == prefix.length()) {
            return this.theValue;
        }
        if (this.childNodes == null) {
            return null;
        }
        char myChar = prefix.charAt(this.charIndex);
        if (myChar < ' ' || myChar > '~') {
            return null;
        }
        ASCIIPrefixTrie<V> child = this.childNodes[myChar];
        if (child == null) {
            return null;
        }
        return child.get(prefix);
    }

    @Override
    public V getShortestMatch(String input) {
        if (this.theValue != null || this.charIndex == input.length() || this.childNodes == null) {
            return this.theValue;
        }
        char myChar = input.charAt(this.charIndex);
        if (myChar < ' ' || myChar > '~') {
            return null;
        }
        ASCIIPrefixTrie<V> child = this.childNodes[myChar];
        if (child == null) {
            return null;
        }
        return child.getShortestMatch(input);
    }

    @Override
    public V getLongestMatch(String input) {
        if (this.charIndex == input.length() || this.childNodes == null) {
            return this.theValue;
        }
        char myChar = input.charAt(this.charIndex);
        if (myChar < ' ' || myChar > '~') {
            return this.theValue;
        }
        ASCIIPrefixTrie<V> child = this.childNodes[myChar];
        if (child == null) {
            return this.theValue;
        }
        V returnValue = child.getLongestMatch(input);
        return returnValue == null ? this.theValue : returnValue;
    }

    @Override
    public void clear() {
        this.childNodes = null;
        this.theValue = null;
    }

    @Override
    public boolean caseSensitive() {
        return this.caseSensitive;
    }
}

